function pm_mainm.init()
	gui_load_gss("pm_menu-common")
	gui_load_gss("pm_main-menu")
		
	local menu = gui_group({id = "menu", group = "main"})
	local title = gui_button({id = "titlehax", label = "Gusanos Menu"})
	local continueBtn = gui_button({id = "continue", label = "X"})
	local win = gui_window({id = "win"})
	
	--win:add()
	--menu:add({continueBtn, win})
	gui_root():add(menu)
	local status = gui_label({id = "status"})
	--status:set_visibility(true)
	--gui_root():add(status)

	local function showStatus(txt)
		status:set_visibility(true)
		status:set_text(txt)
	end
	
	local function hideStatus()
		status:set_visibility(false)
	end
	
	function bindings.transferUpdate(file, bps, done, size)
		msgm.show("Recieving " .. file .. ", " .. floor(100 * done / size) .. "%, " .. round(bps/1000, 2) .. " kB/s")
	end
	
	function bindings.transferFinished()
		hideStatus()
	end
	
	function bindings.gameError(err)
		if err == Error.MapLoading then
			msgm.show("Could not load map")
		elseif err == Error.ModLoading then
			msgm.show("Could not load mod")
		elseif err == Error.MapNotFound then
			msgm.show("Could not find the map")
		elseif err == Error.ModNotFound then
			msgm.show("Could not find the mod")
		end
	end
	
	function bindings.networkStateChange(state)
		if state == Network.Connecting then
			msgm.show("Connecting...")
		elseif state == Network.Disconnecting then
			if wrongPassword then
				msgm.show("Incorrect password")
				wrongPassword = false
			else
				msgm.show("Disconnecting...")
			end
		elseif state == Network.Disconnected then
			msgm.show("Disconnected")
		end
	end
	
	function bindings.gameEnded(reason)
		if reason == EndReason.ServerQuit then
			msgm.show("Server disconnected")
		elseif reason == EndReason.ServerChangeMap then
			msgm.show("Server is changing map...")
		elseif reason == EndReason.Kicked then
			if tooManyPlayers then
				msgm.show("Too many players...")
				tooManyPlayers = false
			else
				msgm.show("You got kicked from the server")
			end
		elseif reason == EndReason.IncompatibleProtocol then
			msgm.show("Your version of gusanos isn't compatible with the server's")
		elseif reason == EndReason.IncompatibleData then
			msgm.show("Your promode is incompatible with the server's")
		end
	end
	
	function pm_mainm.isShown()
		return connectm.isShown() or menu:is_visible()
	end

	function pm_mainm.show()
		if not menu:is_visible() then
			menu:set_visibility(true)
			menu:focus()
			win:focus()
			connectBtn:focus()
		end
	end

	function pm_mainm.hide()
		menu:set_visibility(false)
	end

	function menu:onKeyDown(k)
		if k == Keys.ESC and map_is_loaded() then
			pm_mainm.hide()
			return true
		end
	end

	if map_is_loaded() then
		pm_mainm.hide()
	else
		pm_mainm.show()
	end
	
	function bindings.gameEnded()
		pm_mainm.show()
	end

end
